<ol class="breadcrumb">
	<li><a href="/myqueries/">My queries</a></li>
	<li class="active"><span class="filter-name"><?= $filter->loaded() ? $filter->name : 'New filter'; ?></span></li>
</ol>

<div id="widget-updadd-filter" class="col-md-12">
    <?=Form::open()?>
    <?php if ( isset($errors) ) : ?>
        <?php foreach($errors as $item) : ?>
            <div class="alert alert-danger small"><?= $item ?></div>
        <?php endforeach; ?>
    <?php endif; ?>
    <div class="form-group">
        <label>Name</label>
        <?= Form::input('name', $filter->name, ['class' => 'form-control', 'placeholder' => 'New filter', 'required']); ?>
    </div>
    <?if(Auth::instance()->get_user()->hasAction('Logpost/Mini edit') && $filter->loaded()):?>
    <div class="form-group" ng-controller="logPostMini" ng-init="getList()">
        <label>MiniUsers</label>
        <select name='users[]' class="form-control" multiple="multiple">
            <option ng-repeat="user in listUsers" ng-selected="user.selected" value="{{ user.id }}">{{user.username}}</option>
        </select>
    </div>
    <?else:?>
        <div class="form-group">
            <label>MiniUsers</label>
                <div class="alert alert-danger">Available after creation</div>
        </div>
    <?endif;?>
    <table class="table table-striped">
        <thead>
            <tr style="font-weight: bold">
                <td>
                    Net
                </td>
                <td>
                    Length
                </td>
                <td>
                    Referrer
                </td>
                <td>
                    Link
                </td>
                <td>
                    Ip
                </td>
                <td>
                    Date range
                </td>
                <td>
                    Version
                </td>
                <td></td>
            </tr>
        </thead>
        <tbody>
            <?php  ?>
            <tr>
                <td>
                    <?= Form::input('net[]', Arr::get($filter_net, 0), ['class' => 'form-control', 'style' => 'margin-top: 27px;']); ?>
                </td>
                <td>
                    <?= Form::input('length', $filter->length, ['class' => 'form-control', 'style' => 'margin-top: 27px;']); ?>
                </td>
                <td>
                    <?= Form::input('referrer[]', Arr::get($filter_referrer, 0), ['class' => 'form-control', 'style' => 'margin-top: 27px;']); ?>
                </td>
                <td>
                    <label>
                        <?= Form::checkbox('link_strong', '1', (bool)$filter->link_strong); ?>
                        Strong?
                    </label>
                    <?= Form::input('link[]', Arr::get($filter_link, 0), ['class' => 'form-control']); ?>
                </td>
                <td>
                    <?= Form::input('ip[]', Arr::get($filter_ip, 0), ['class' => 'form-control', 'style' => 'margin-top: 27px;']); ?>
                </td>
                <td>
                    <div class="input-daterange input-group datepicker-range" style="margin-top: 27px;">
                        <?= Form::input('date_start', $filter->date_start, ['class' => 'form-control']); ?>
                        <span class="input-group-addon"> / </span>
                        <?= Form::input('date_end', $filter->date_end, ['class' => 'form-control']); ?>
                    </div>
                </td>
                <td>
                    <?= Form::input('version', $filter->version, ['class' => 'form-control', 'style' => 'margin-top: 27px;']); ?>
                </td>
                <td></td>
            </tr>
            <?php for($i = 1; $i <= $countAdditionalRows + 1; ++$i) : ?>
            <tr>
                <td>
                    <?= Form::input('net[]', Arr::get($filter_net, $i), ['class' => 'form-control']); ?>
                </td>
                <td></td>
                <td>
                    <?= Form::input('referrer[]', Arr::get($filter_referrer, $i), ['class' => 'form-control']); ?>
                </td>
                <td>
                    <?= Form::input('link[]', Arr::get($filter_link, $i), ['class' => 'form-control']); ?>
                </td>
                <td>
                    <?= Form::input('ip[]', Arr::get($filter_ip, $i), ['class' => 'form-control']); ?>
                </td>
                <td></td>
                <td></td>
                <td>
                    <?= Form::button(null, '<span class="glyphicon glyphicon-remove"></span>', ['class' => 'btn btn-danger remove-row', 'type' => 'button']); ?>
                </td>
            </tr>
            <?php endfor; ?>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="9">
                    <div class="row">
                        <p>
                            <?= Form::button(null, '<span class="glyphicon glyphicon-plus"></span>', ['class' => 'btn btn-success pull-right add-row', 'style' => 'margin-right: 15px;', 'type' => 'button']); ?>
                            <div class="clearfix"></div>
                        </p>
                    </div>
                    <div class="row">
                        <?= Form::button('apply', $filter->loaded() ? 'Update' : 'Add', ['class' => 'btn btn-success pull-right', 'style' => 'margin-right: 15px;']); ?>
                        <a class="pull-right" style="margin-right: 15px; margin-top: 8px;" href="/myqueries">Cancel</a>
                        <div class="clearfix"></div>
                    </div>
                </td>
            </tr>
        </tfoot>
    <table>
    <?=Form::close()?>
</div>

<script>
    $(document).ready(function() {
        'use strict';
        
        var $filterName = $('.filter-name');
        var $scopeWidget = $('#widget-updadd-filter');
        var $table = $('table', $scopeWidget);
        
        $('.datepicker-range', $scopeWidget).datepicker({
            language: "ru",
            autoclose: true,
            todayHighlight: true,
            format: "yyyy/mm/dd"
        });
        
        // http://stackoverflow.com/questions/24981072/bootstrap-datepicker-empties-field-after-selecting-current-date
        $('.datepicker-range :input', $scopeWidget).each(function() {
            if ('' != $(this).val()) {
                $(this).one('show', function(e) {
                    if ( e.date ) {
                         $(this).data('stickyDate', e.date);
                    } else {
                         $(this).data('stickyDate', null);
                    }
                });
                $(this).one('hide', function(e){
                    var stickyDate = $(this).data('stickyDate');

                    if ( !e.date && stickyDate ) {
                        $(this).datepicker('setDate', stickyDate);
                        $(this).data('stickyDate', null);
                    }
                });
            }
        });
        
        $(':input[name="name"]', $scopeWidget).on('keydown input propertychange change', function() {
            var name = $(this).val();
            if ('' == name) {
                name = 'New filter';
            }
            $filterName.html(name);
        });
        
        var removeRow = function(e) {
            e.preventDefault();
            $(this).closest('tr').remove();
        };
        $('tbody tr .remove-row', $table).on('click', removeRow);
        
        $('.add-row', $scopeWidget).on('click', function(e) {
            e.preventDefault();
            var tr = '' +
                '<tr>' +
                    '<td>' +
                        '<input type="text" name="net[]" class="form-control">' +
                    '</td>' +
                    '<td></td>' +
                    '<td>' +
                        '<input type="text" name="referrer[]" class="form-control">' +
                    '</td>' +
                    '<td>' +
                        '<input type="text" name="link[]" class="form-control">' +
                    '</td>' +
                    '<td>' +
                        '<input type="text" name="ip[]" class="form-control">' +
                    '</td>' +
                    '<td></td>' +
                    '<td></td>' +
                    '<td>' +
                        '<button type="button" class="btn btn-danger remove-row"><span class="glyphicon glyphicon-remove"></span></button>' +
                    '</td>' +
                '</tr>';
            var $tr = $(tr);
            $('.remove-row', $tr).on('click', removeRow);
            $('tbody', $table).append($tr);
        });
    });
</script>

<?if(Auth::instance()->get_user()->hasAction('Logpost/Mini edit') && $filter->loaded()):?>
    <script>
        $(function () {
            $('select[name="users[]"]').select2({
                placeholder: "Users",
                tags: true,
                allowClear: true
            }).data('select2').$container.addClass("input-sm").css('padding', 0);
        });

        app.directive('onFinishRender', function () {
            return {
                restrict: 'A',
                link: function (scope, element, attr) {
                    scope.$evalAsync(attr.onFinishRender);
                }
            }
        });

        app.controller('logPostMini', function($controller, $scope, $http, $timeout){
            $scope.listUsers = {};
            $scope.init = false;

            $scope.upd = function () {
                var objects = $('select[name="users[]"]').select2('data');
                var list = [];
                for(var key in objects) {
                    list.push({
                        'id': <?=$filter->id?>,
                        'user_id': objects[key]['id']
                    });
                }
                $http.post('/rest/mini/upd', {list: list, id: <?=$filter->id?>}).then(function(data){
                    console.log(data['data']);
                });
            };

            $scope.getList = function () {
                $('select[name="users[]"]').on('select2:select', $scope.upd);
                $('select[name="users[]"]').on('select2:unselect', $scope.upd);

                $http.post('/rest/mini/index', {'id': <?=$filter->id?>}).then(function(data){
                    $scope.listUsers = data['data'];
                    $timeout(function () {
                        $('select[name="users[]"]').trigger('change.select2');
                        $scope.init = true;
                    });
                });
            };
        });
    </script>
<?endif;?>